/*
GMCOM2.CPP
Copyright (C) 11/6/2002 by Greg Wittmeyer
All Rights Reserved

This source code file is compiled into GMCOM2.EXE.  It is a command line
interface to the Gammadyne Mailer Email Sending Engine in GMCOM.DLL.

This variant interfaces with GMCOM.DLL via direct DLL linking.
*/

#ifdef _DEBUG
  #error No Debug!
#endif

#pragma warning(disable : 4121)	// alignment of a member was sensitive to packing
#pragma warning(disable : 4163)	// not available as an intrinsic function
#pragma warning(disable : 4577)	// 'noexcept' used with no exception handling

#include <windows.h>
#include <stdio.h>

char *PROJECT_ERROR = "*** Pseudo-Project Error ***";


/*
Return an English description of the specified system error code.
*/
const char *scs_describe()
{
DWORD error_code = GetLastError();
if(error_code==ERROR_SUCCESS)
	return "";

static LPVOID lpMsgBuf = NULL;

// if this function was called before, free the message buffer
if(lpMsgBuf) {
	LocalFree(lpMsgBuf);
	lpMsgBuf = NULL;
	}

// get the message string
FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
	NULL, error_code, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
	(LPTSTR) &lpMsgBuf, 0, NULL);

return lpMsgBuf ? (const char *)lpMsgBuf : "";
}


/*
Main
*/
void __cdecl main(int argc, char **argv)
{
// parse the command line
int i;
enum { MODE_NONE, MODE_HELP, MODE_SEND_FILE } mode = MODE_NONE;
char *filepath = NULL;
bool nologo = false;	// Hide the program banner.
bool nostats = false;	// Don't report performance stats.
bool noerr = false;	// Don't report errors.
bool nosum = false;	// Don't report the operation summary (sent, failed, etc.).

for(i = 1; i < argc; i++) {
	char *arg = argv[i];

	if(strchr("/+-", *arg)) {
		// this is a switch
		arg++;

		if(!strcmp(arg, "?")) {
			mode = MODE_HELP;
			continue;
			}

		if(!_strcmpi(arg, "nologo")) {
			nologo = true;
			continue;
			}

		if(!_strcmpi(arg, "nostats")) {
			nostats = true;
			continue;
			}

		if(!_strcmpi(arg, "nosum")) {
			nosum = true;
			continue;
			}

		if(!_strcmpi(arg, "noerr")) {
			noerr = true;
			continue;
			}

		if(!_strcmpi(arg, "q")) {
			noerr = nostats = nologo = nosum = true;
			continue;
			}

		printf("Invalid command line switch: %s\r\n", arg);
		return;
		}

	// not a switch
	if(mode != MODE_NONE) {
		printf("Unexpected command line parameter: %s\r\n", arg);
		return;
		}

	mode = MODE_SEND_FILE;
	filepath = arg;
	}

// banner
if(!nologo) {
	puts("GMCOM2.EXE - Gammadyne Mailer Command Line Module");
	puts("Copyright (C) 2002-2020 by Gammadyne Corporation - All Rights Reserved\r\n");
	}

// help
if(mode != MODE_SEND_FILE) {
	puts("Usage:  gmcom2.exe [/noerr] [/nologo] [/nostats] [/nosum] [/q] filepath\r\n");
	puts("/noerr   Suppress output of error messages.");
	puts("/nologo  Suppress output of program banner.");
	puts("/nostats Suppress output of operation performance statistics.");
	puts("/nosum   Suppress output of operation summary.");
	puts("/q       Suppress all output.");
	puts("filepath The path and filename of the pseudo-project file.");
	return;
	}

// load the DLL
HMODULE dll = LoadLibrary("gmcom.dll");
if(!dll) {
	puts("Failed to link to gmcom.dll");
	puts(scs_describe());
	return;
	}

// link to each function
#define DllExport __stdcall
typedef int (DllExport *F_load_mem)(const char *);
typedef int (DllExport *F_load_file)(const char *);
typedef int (DllExport *F_get_successful_sends)();
typedef int (DllExport *F_get_failed_sends)();
typedef int (DllExport *F_send_messages)();
typedef const char * (DllExport *F_get_error_description)();
typedef const char * (DllExport *F_get_summary)();
typedef const char * (DllExport *F_get_stats)();

F_load_mem load_mem = (F_load_mem)GetProcAddress(dll, "g_load_mem");
F_load_file load_file = (F_load_file)GetProcAddress(dll, "g_load_file");
F_get_successful_sends get_successful_sends = (F_get_successful_sends)GetProcAddress(dll, "g_get_successful_sends");
F_get_failed_sends get_failed_sends = (F_get_failed_sends)GetProcAddress(dll, "g_get_failed_sends");
F_send_messages send_messages = (F_send_messages)GetProcAddress(dll, "g_send_messages");
F_get_error_description error_description_get = (F_get_error_description)GetProcAddress(dll, "g_get_error_description");
F_get_summary get_summary = (F_get_summary)GetProcAddress(dll, "g_get_summary");
F_get_stats get_stats = (F_get_stats)GetProcAddress(dll, "g_get_stats");

if(!load_mem || !load_file || !get_successful_sends || !get_failed_sends || !send_messages || !error_description_get || !get_summary || !get_stats) {
	puts("GetProcAddress() Error!");
	return;
	}

// load the project settings
/*
int success = load_mem(
	"From:foo@bar.com\r\n"
	"Recipients:foo@bar.com\r\n"
	"TextBody:it works!\r\n"
	"DirectDelivery:1\r\n"
	"LogFile:c:\\killme.log\r\n"
	);
*/

int success = load_file(filepath);

int status = 0;

if(!success) {
	// error in project
	if(!noerr)
		puts(PROJECT_ERROR);
} else {
	// run the send operation
	status = send_messages();

	if(!status) {
		// error in project
		if(!noerr)
			puts(PROJECT_ERROR);
		}
	}

// report any error information
if(!noerr) {
	const char *error = error_description_get();
	if(error && *error) {
		puts(error);
		}
	}

// report the operation results
if(status) {
	/*
	int success_count = get_successful_sends();
	printf("Successful sends: %d\r\n", success_count);

	int failure_count = get_failed_sends();
	printf("Failed sends: %d\r\n", failure_count);
	*/

	// report the operation summary
	if(!nosum) {
		const char *summary = get_summary();
		if(summary)
			puts(summary);
		}

	// report the performance stats
	if(!nostats) {
		const char *stats = get_stats();
		if(stats)
			puts(stats);
		}
	}

// release the Gammadyne Mailer Engine object
FreeLibrary(dll);
}
